// Global theme listener content script
// Injected on all pages to sync OS/Chrome theme to storage
(() => {
  try {
    const media = window.matchMedia('(prefers-color-scheme: dark)');

    const syncTheme = () => {
      try {
        // Write directly to storage - more reliable than messages
        // Background script's storage listener will update the icon
        chrome.storage.sync.set({ uiTheme: media.matches ? 'dark' : 'light' });
      } catch {}
    };

    // Initial sync
    syncTheme();

    // Listen for changes
    if (typeof media.addEventListener === 'function') {
      media.addEventListener('change', syncTheme);
    } else if (typeof media.addListener === 'function') {
      media.addListener(syncTheme);
    }

    // Also sync when tab becomes visible again (covers some OS theme switches)
    document.addEventListener('visibilitychange', () => {
      if (!document.hidden) syncTheme();
    });
  } catch (e) {
    // Silent fail
  }
})();
